<?php
$vc_is_wp_version_3_6_more = version_compare(preg_replace('/^([\d\.]+)(\-.*$)/', '$1', get_bloginfo('version')), '3.6') >= 0;
$custom_sidebars           = $pages = $posts = $categories = $layer_slider = $edge_posts = $sliders = $rev_slider = $testimonials = $clients = $news_posts = $portfolio_posts = $flexslider = $employees = $pricing = array();
$sidebars                  = get_option(THEME_OPTIONS);
if (!empty($sidebars['sidebars'])) {
     $sidebars_array  = explode(',', $sidebars['sidebars']);
     $custom_sidebars = array();
     foreach ($sidebars_array as $sidebar) {
          $custom_sidebars[$sidebar] = $sidebar;
     }
}
$target_arr      = array(
     __("Same window", "mk_framework") => "_self",
     __("New window", "mk_framework") => "_blank"
);
$pricing_entries = get_posts('post_type=pricing&orderby=title&numberposts=-1&order=ASC');
if ($pricing_entries != null && !empty($pricing_entries)) {
     foreach ($pricing_entries as $key => $entry) {
          $pricing[$entry->ID] = $entry->post_title;
     }
}
$employees_entries = get_posts('post_type=employees&orderby=title&numberposts=-1&order=ASC');
if ($employees_entries != null && !empty($employees_entries)) {
     foreach ($employees_entries as $key => $entry) {
          $employees[$entry->ID] = $entry->post_title;
     }
}
$flexslider_entries = get_posts('post_type=slideshow&orderby=title&numberposts=-1&order=ASC');
if ($flexslider_entries != null && !empty($flexslider_entries)) {
     foreach ($flexslider_entries as $key => $entry) {
          $flexslider[$entry->ID] = $entry->post_title;
     }
}
$edge_entries = get_posts('post_type=edge&orderby=title&numberposts=-1&order=ASC');
if ($edge_entries != null && !empty($edge_entries)) {
     foreach ($edge_entries as $key => $entry) {
          $edge_posts[$entry->ID] = $entry->post_title;
     }
}
$portfolio_entries = get_posts('post_type=portfolio&orderby=title&numberposts=-1&order=ASC');
foreach ($portfolio_entries as $key => $entry) {
     $portfolio_posts[$entry->ID] = $entry->post_title;
}
$posts_entries = get_posts('post_type=post&orderby=title&numberposts=-1&order=ASC');
foreach ($posts_entries as $key => $entry) {
     $posts[$entry->ID] = $entry->post_title;
}
$news_entries = get_posts('post_type=news&orderby=title&numberposts=-1&order=ASC');
foreach ($news_entries as $key => $entry) {
     $news_posts[$entry->ID] = $entry->post_title;
}
$clients_entries = get_posts('post_type=clients&orderby=title&numberposts=-1&order=ASC');
if ($clients_entries != null && !empty($clients_entries)) {
     foreach ($clients_entries as $key => $entry) {
          $clients[$entry->ID] = $entry->post_title;
     }
}
$testimonials_entries = get_posts('post_type=testimonial&orderby=title&numberposts=-1&order=ASC');
if ($testimonials_entries != null && !empty($testimonials_entries)) {
     foreach ($testimonials_entries as $key => $entry) {
          $testimonials[$entry->ID] = $entry->post_title;
     }
}
$page_entries = get_pages('title_li=&orderby=name');
foreach ($page_entries as $key => $entry) {
     $pages['None']             = "*";
     $pages[$entry->post_title] = $entry->ID;
}
$cats_entries = get_categories('orderby=name&hide_empty=0');
foreach ($cats_entries as $key => $entry) {
     $categories[$entry->term_id] = $entry->name;
}
global $wpdb;
$table_name = $wpdb->prefix . "layerslider";
if ($wpdb->get_var("SHOW TABLES LIKE '$table_name'") == $table_name) {
     $sliders = $wpdb->get_results("SELECT * FROM $table_name
                                    WHERE flag_hidden = '0' AND flag_deleted = '0'
                                    ORDER BY date_c ASC LIMIT 100");
}
if ($sliders != null && !empty($sliders)) {
     foreach ($sliders as $item):
          $layer_slider[$item->name] = $item->id;
     endforeach;
}
if (class_exists('RevSlider')) {
     $slider     = new RevSlider();
     $arrSliders = $slider->getArrSlidersShort();
     foreach ($arrSliders as $key => $entry) {
          $rev_slider[$entry] = $key;
     }
}
global $wpdb;
$order    = 'user_id';
$authors  = '';
$user_ids = $wpdb->get_col($wpdb->prepare("SELECT $wpdb->usermeta.user_id FROM $wpdb->usermeta where meta_key='wp_user_level' and meta_value>=1 ORDER BY %s ASC", $order));
if ($user_ids != null && !empty($user_ids)) {
     foreach ($user_ids as $user_id):
          $user              = get_userdata($user_id);
          $authors[$user_id] = $user->display_name;
     endforeach;
}
$css_animations        = array(
     "None" => '',
     "Fade In" => "fade-in",
     "Scale Up" => "scale-up",
     "Right to Left" => "right-to-left",
     "Left to Right" => "left-to-right",
     "Bottom to Top" => "bottom-to-top",
     "Top to Bottom" => "top-to-bottom",
     "Flip Horizontally" => "flip-x",
     "Flip Vertically" => "flip-y"
);
$device_visibility     = array(
     "All" => '',
     "Hidden on Phones" => "hidden-sm",
     "Hidden on Tablets" => "hidden-tl",
     "Hidden on Desktops" => "hidden-dt",
     "Visible on Phones" => "visible-sm",
     "Visible on Tablets" => "visible-tl",
     "Visible on Desktops" => "visible-dt"
);
$mk_orderby            = array(
     __("Date", 'mk_framework') => "date",
     __('Menu Order', 'mk_framework') => 'menu_order',
     __("Posts In (manually selected posts)", 'mk_framework') => "post__in",
     __("post id", 'mk_framework') => "id",
     __("title", 'mk_framework') => "title",
     __("Comment Count", 'mk_framework') => "comment_count",
     __("Random", 'mk_framework') => "rand",
     __("Author", 'mk_framework') => "author",
     __("No order", 'mk_framework') => "none"
);
$mk_awesome_icons_list = array(
     '' => '',
     "moon-home" => "21",
     "moon-home-2" => "22",
     "moon-home-3" => "23",
     "moon-home-4" => "24",
     "moon-home-5" => "25",
     "moon-home-6" => "26",
     "moon-quill" => "27",
     "moon-quill-2" => "28",
     "moon-pen" => "29",
     "moon-pen-2" => "2a",
     "moon-pen-3" => "2b",
     "moon-pen-4" => "2c",
     "moon-droplet" => "2d",
     "moon-paint-format" => "2e",
     "moon-paint-format-2" => "2f",
     "moon-image" => "30",
     "moon-image-2" => "31",
     "moon-image-3" => "32",
     "moon-music" => "33",
     "moon-music-2" => "34",
     "moon-piano" => "35",
     "moon-guitar" => "36",
     "moon-headphones" => "37",
     "moon-headphones-2" => "38",
     "moon-dice" => "39",
     "moon-gamepad" => "3a",
     "moon-gamepad-2" => "3b",
     "moon-gamepad-3" => "3c",
     "moon-pacman" => "3d",
     "moon-spades" => "3e",
     "moon-podcast" => "3f",
     "moon-radio" => "40",
     "moon-feed" => "41",
     "moon-connection" => "42",
     "moon-radio-2" => "43",
     "moon-podcast-2" => "44",
     "moon-profile" => "45",
     "moon-file" => "46",
     "moon-file-2" => "47",
     "moon-file-3" => "48",
     "moon-file-4" => "49",
     "moon-file-5" => "4a",
     "moon-file-remove" => "4b",
     "moon-file-6" => "4c",
     "moon-copy" => "4d",
     "moon-copy-2" => "4e",
     "moon-copy-3" => "4f",
     "moon-copy-4" => "50",
     "moon-folder-remove" => "51",
     "moon-folder" => "52",
     "moon-folder-open" => "53",
     "moon-folder-2" => "54",
     "moon-folder-3" => "55",
     "moon-folder-plus" => "56",
     "moon-tag" => "57",
     "moon-tag-2" => "58",
     "moon-tag-3" => "59",
     "moon-tag-4" => "5a",
     "moon-tag-5" => "5b",
     "moon-tag-6" => "5c",
     "moon-cart-plus" => "5d",
     "moon-cart-minus" => "5e",
     "moon-cart-add" => "5f",
     "moon-cart-remove" => "60",
     "moon-cart-checkout" => "61",
     "moon-cart-remove-2" => "62",
     "moon-phone" => "63",
     "moon-phone-2" => "64",
     "moon-contact-add" => "65",
     "moon-contact-remove" => "66",
     "moon-contact-add-2" => "67",
     "moon-contact-remove-2" => "68",
     "moon-pushpin" => "69",
     "moon-location" => "6a",
     "moon-location-2" => "6b",
     "moon-location-3" => "6c",
     "moon-location-4" => "6d",
     "moon-location-5" => "6e",
     "moon-location-6" => "6f",
     "moon-location-7" => "70",
     "moon-compass" => "71",
     "moon-compass-2" => "72",
     "moon-map" => "73",
     "moon-map-2" => "74",
     "moon-map-3" => "75",
     "moon-map-4" => "76",
     "moon-direction" => "77",
     "moon-history" => "78",
     "moon-history-2" => "79",
     "moon-clock" => "7a",
     "moon-clock-2" => "7b",
     "moon-clock-3" => "7c",
     "moon-clock-4" => "7d",
     "moon-watch" => "7e",
     "moon-clock-5" => "e000",
     "moon-clock-6" => "e001",
     "moon-clock-7" => "e002",
     "moon-alarm" => "e003",
     "moon-alarm-2" => "e004",
     "moon-bell" => "e005",
     "moon-bell-2" => "e006",
     "moon-alarm-plus" => "e007",
     "moon-alarm-minus" => "e008",
     "moon-alarm-check" => "e009",
     "moon-alarm-cancel" => "e00a",
     "moon-stopwatch" => "e00b",
     "moon-calendar" => "e00c",
     "moon-calendar-2" => "e00d",
     "moon-calendar-3" => "e00e",
     "moon-calendar-4" => "e00f",
     "moon-calendar-5" => "e010",
     "moon-print" => "e011",
     "moon-print-2" => "e012",
     "moon-print-3" => "e013",
     "moon-mouse" => "e014",
     "moon-mouse-2" => "e015",
     "moon-mouse-3" => "e016",
     "moon-mouse-4" => "e017",
     "moon-keyboard" => "e018",
     "moon-keyboard-2" => "e019",
     "moon-screen" => "e01a",
     "moon-screen-2" => "e01b",
     "moon-screen-3" => "e01c",
     "moon-screen-4" => "e01d",
     "moon-laptop" => "e01e",
     "moon-mobile" => "e01f",
     "moon-mobile-2" => "e020",
     "moon-tablet" => "e021",
     "moon-mobile-3" => "e022",
     "moon-tv" => "e023",
     "moon-cabinet" => "e024",
     "moon-archive" => "e025",
     "moon-drawer" => "e026",
     "moon-drawer-2" => "e027",
     "moon-drawer-3" => "e028",
     "moon-box" => "e029",
     "moon-box-add" => "e02a",
     "moon-box-remove" => "e02b",
     "moon-download" => "e02c",
     "moon-upload" => "e02d",
     "moon-disk" => "e02e",
     "moon-cd" => "e02f",
     "moon-storage" => "e030",
     "moon-storage-2" => "e031",
     "moon-database" => "e032",
     "moon-database-2" => "e033",
     "moon-database-3" => "e034",
     "moon-undo" => "e035",
     "moon-redo" => "e036",
     "moon-rotate" => "e037",
     "moon-rotate-2" => "e038",
     "moon-flip" => "e039",
     "moon-flip-2" => "e03a",
     "moon-unite" => "e03b",
     "moon-subtract" => "e03c",
     "moon-interset" => "e03d",
     "moon-exclude" => "e03e",
     "moon-align-left" => "e03f",
     "moon-align-center-horizontal" => "e040",
     "moon-align-right" => "e041",
     "moon-align-top" => "e042",
     "moon-align-center-vertical" => "e043",
     "moon-align-bottom" => "e044",
     "moon-undo-2" => "e045",
     "moon-redo-2" => "e046",
     "moon-forward" => "e047",
     "moon-reply" => "e048",
     "moon-reply-2" => "e049",
     "moon-bubble" => "e04a",
     "moon-bubbles" => "e04b",
     "moon-bubbles-2" => "e04c",
     "moon-bubble-2" => "e04d",
     "moon-bubbles-3" => "e04e",
     "moon-bubbles-4" => "e04f",
     "moon-bubble-notification" => "e050",
     "moon-bubbles-5" => "e051",
     "moon-bubbles-6" => "e052",
     "moon-bubble-3" => "e053",
     "moon-bubble-dots" => "e054",
     "moon-bubble-4" => "e055",
     "moon-bubble-5" => "e056",
     "moon-bubble-dots-2" => "e057",
     "moon-bubble-6" => "e058",
     "moon-bubble-7" => "e059",
     "moon-bubble-8" => "e05a",
     "moon-bubbles-7" => "e05b",
     "moon-bubble-9" => "e05c",
     "moon-bubbles-8" => "e05d",
     "moon-bubble-10" => "e05e",
     "moon-bubble-dots-3" => "e05f",
     "moon-bubble-11" => "e060",
     "moon-bubble-12" => "e061",
     "moon-bubble-dots-4" => "e062",
     "moon-bubble-13" => "e063",
     "moon-bubbles-9" => "e064",
     "moon-bubbles-10" => "e065",
     "moon-bubble-blocked" => "e066",
     "moon-bubble-quote" => "e067",
     "moon-bubble-user" => "e068",
     "moon-bubble-check" => "e069",
     "moon-bubble-video-chat" => "e06a",
     "moon-bubble-link" => "e06b",
     "moon-bubble-locked" => "e06c",
     "moon-bubble-star" => "e06d",
     "moon-bubble-heart" => "e06e",
     "moon-bubble-paperclip" => "e06f",
     "moon-bubble-cancel" => "e070",
     "moon-bubble-plus" => "e071",
     "moon-bubble-minus" => "e072",
     "moon-bubble-notification-2" => "e073",
     "moon-bubble-trash" => "e074",
     "moon-bubble-left" => "e075",
     "moon-bubble-right" => "e076",
     "moon-bubble-up" => "e077",
     "moon-bubble-down" => "e078",
     "moon-bubble-first" => "e079",
     "moon-bubble-last" => "e07a",
     "moon-bubble-replu" => "e07b",
     "moon-bubble-forward" => "e07c",
     "moon-bubble-reply" => "e07d",
     "moon-bubble-forward-2" => "e07e",
     "moon-user" => "e07f",
     "moon-users" => "e080",
     "moon-user-plus" => "e081",
     "moon-user-plus-2" => "e082",
     "moon-user-minus" => "e083",
     "moon-user-minus-2" => "e084",
     "moon-user-cancel" => "e085",
     "moon-user-block" => "e086",
     "moon-users-2" => "e087",
     "moon-user-2" => "e088",
     "moon-users-3" => "e089",
     "moon-user-plus-3" => "e08a",
     "moon-user-minus-3" => "e08b",
     "moon-user-cancel-2" => "e08c",
     "moon-user-block-2" => "e08d",
     "moon-user-3" => "e08e",
     "moon-user-4" => "e08f",
     "moon-user-5" => "e090",
     "moon-user-6" => "e091",
     "moon-users-4" => "e092",
     "moon-user-7" => "e093",
     "moon-user-8" => "e094",
     "moon-users-5" => "e095",
     "moon-vcard" => "e096",
     "moon-tshirt" => "e097",
     "moon-hanger" => "e098",
     "moon-quotes-left" => "e099",
     "moon-quotes-right" => "e09a",
     "moon-quotes-right-2" => "e09b",
     "moon-quotes-right-3" => "e09c",
     "moon-busy" => "e09d",
     "moon-busy-2" => "e09e",
     "moon-busy-3" => "e09f",
     "moon-busy-4" => "e0a0",
     "moon-spinner" => "e0a1",
     "moon-spinner-2" => "e0a2",
     "moon-spinner-3" => "e0a3",
     "moon-spinner-4" => "e0a4",
     "moon-spinner-5" => "e0a5",
     "moon-spinner-6" => "e0a6",
     "moon-spinner-7" => "e0a7",
     "moon-spinner-8" => "e0a8",
     "moon-spinner-9" => "e0a9",
     "moon-spinner-10" => "e0aa",
     "moon-spinner-11" => "e0ab",
     "moon-spinner-12" => "e0ac",
     "moon-microscope" => "e0ad",
     "moon-binoculars" => "e0ae",
     "moon-binoculars-2" => "e0af",
     "moon-search" => "e0b0",
     "moon-search-2" => "e0b1",
     "moon-zoom-in" => "e0b2",
     "moon-zoom-out" => "e0b3",
     "moon-search-3" => "e0b4",
     "moon-search-4" => "e0b5",
     "moon-zoom-in-2" => "e0b6",
     "moon-zoom-out-2" => "e0b7",
     "moon-search-5" => "e0b8",
     "moon-expand" => "e0b9",
     "moon-contract" => "e0ba",
     "moon-scale-up" => "e0bb",
     "moon-scale-down" => "e0bc",
     "moon-expand-2" => "e0bd",
     "moon-contract-2" => "e0be",
     "moon-scale-up-2" => "e0bf",
     "moon-scale-down-2" => "e0c0",
     "moon-fullscreen" => "e0c1",
     "moon-expand-3" => "e0c2",
     "moon-contract-3" => "e0c3",
     "moon-key" => "e0c4",
     "moon-key-2" => "e0c5",
     "moon-key-3" => "e0c6",
     "moon-key-4" => "e0c7",
     "moon-key-5" => "e0c8",
     "moon-keyhole" => "e0c9",
     "moon-lock" => "e0ca",
     "moon-lock-2" => "e0cb",
     "moon-lock-3" => "e0cc",
     "moon-lock-4" => "e0cd",
     "moon-unlocked" => "e0ce",
     "moon-lock-5" => "e0cf",
     "moon-unlocked-2" => "e0d0",
     "moon-wrench" => "e0d1",
     "moon-wrench-2" => "e0d2",
     "moon-wrench-3" => "e0d3",
     "moon-wrench-4" => "e0d4",
     "moon-settings" => "e0d5",
     "moon-equalizer" => "e0d6",
     "moon-equalizer-2" => "e0d7",
     "moon-equalizer-3" => "e0d8",
     "moon-cog" => "e0d9",
     "moon-cogs" => "e0da",
     "moon-cog-2" => "e0db",
     "moon-cog-3" => "e0dc",
     "moon-cog-4" => "e0dd",
     "moon-cog-5" => "e0de",
     "moon-cog-6" => "e0df",
     "moon-cog-7" => "e0e0",
     "moon-factory" => "e0e1",
     "moon-hammer" => "e0e2",
     "moon-tools" => "e0e3",
     "moon-screwdriver" => "e0e4",
     "moon-screwdriver-2" => "e0e5",
     "moon-wand" => "e0e6",
     "moon-wand-2" => "e0e7",
     "moon-health" => "e0e8",
     "moon-aid" => "e0e9",
     "moon-patch" => "e0ea",
     "moon-bug" => "e0eb",
     "moon-bug-2" => "e0ec",
     "moon-inject" => "e0ed",
     "moon-inject-2" => "e0ee",
     "moon-construction" => "e0ef",
     "moon-cone" => "e0f0",
     "moon-pie" => "e0f1",
     "moon-pie-2" => "e0f2",
     "moon-pie-3" => "e0f3",
     "moon-pie-4" => "e0f4",
     "moon-pie-5" => "e0f5",
     "moon-pie-6" => "e0f6",
     "moon-pie-7" => "e0f7",
     "moon-stats" => "e0f8",
     "moon-stats-2" => "e0f9",
     "moon-stats-3" => "e0fa",
     "moon-bars" => "e0fb",
     "moon-bars-2" => "e0fc",
     "moon-bars-3" => "e0fd",
     "moon-bars-4" => "e0fe",
     "moon-bars-5" => "e0ff",
     "moon-bars-6" => "e100",
     "moon-stats-up" => "e101",
     "moon-stats-down" => "e102",
     "moon-stairs-down" => "e103",
     "moon-stairs-down-2" => "e104",
     "moon-chart" => "e105",
     "moon-stairs" => "e106",
     "moon-stairs-2" => "e107",
     "moon-ladder" => "e108",
     "moon-cake" => "e109",
     "moon-gift" => "e10a",
     "moon-gift-2" => "e10b",
     "moon-balloon" => "e10c",
     "moon-rating" => "e10d",
     "moon-rating-2" => "e10e",
     "moon-rating-3" => "e10f",
     "moon-podium" => "e110",
     "moon-medal" => "e111",
     "moon-medal-2" => "e112",
     "moon-medal-3" => "e113",
     "moon-medal-4" => "e114",
     "moon-medal-5" => "e115",
     "moon-crown" => "e116",
     "moon-trophy" => "e117",
     "moon-trophy-2" => "e118",
     "moon-trophy-star" => "e119",
     "moon-diamond" => "e11a",
     "moon-diamond-2" => "e11b",
     "moon-glass" => "e11c",
     "moon-glass-2" => "e11d",
     "moon-bottle" => "e11e",
     "moon-bottle-2" => "e11f",
     "moon-mug" => "e120",
     "moon-food" => "e121",
     "moon-food-2" => "e122",
     "moon-hamburger" => "e123",
     "moon-cup" => "e124",
     "moon-cup-2" => "e125",
     "moon-leaf" => "e126",
     "moon-leaf-2" => "e127",
     "moon-apple-fruit" => "e128",
     "moon-tree" => "e129",
     "moon-tree-2" => "e12a",
     "moon-paw" => "e12b",
     "moon-steps" => "e12c",
     "moon-flower" => "e12d",
     "moon-rocket" => "e12e",
     "moon-meter" => "e12f",
     "moon-meter2" => "e130",
     "moon-meter-slow" => "e131",
     "moon-meter-medium" => "e132",
     "moon-meter-fast" => "e133",
     "moon-dashboard" => "e134",
     "moon-hammer-2" => "e135",
     "moon-balance" => "e136",
     "moon-bomb" => "e137",
     "moon-fire" => "e138",
     "moon-fire-2" => "e139",
     "moon-lab" => "e13a",
     "moon-atom" => "e13b",
     "moon-atom-2" => "e13c",
     "moon-magnet" => "e13d",
     "moon-magnet-2" => "e13e",
     "moon-magnet-3" => "e13f",
     "moon-magnet-4" => "e140",
     "moon-dumbbell" => "e141",
     "moon-skull" => "e142",
     "moon-skull-2" => "e143",
     "moon-skull-3" => "e144",
     "moon-lamp" => "e145",
     "moon-lamp-2" => "e146",
     "moon-lamp-3" => "e147",
     "moon-lamp-4" => "e148",
     "moon-remove" => "e149",
     "moon-remove-2" => "e14a",
     "moon-remove-3" => "e14b",
     "moon-remove-4" => "e14c",
     "moon-remove-5" => "e14d",
     "moon-remove-6" => "e14e",
     "moon-remove-7" => "e14f",
     "moon-remove-8" => "e150",
     "moon-briefcase" => "e151",
     "moon-briefcase-2" => "e152",
     "moon-briefcase-3" => "e153",
     "moon-airplane" => "e154",
     "moon-airplane-2" => "e155",
     "moon-paper-plane" => "e156",
     "moon-car" => "e157",
     "moon-gas-pump" => "e158",
     "moon-bus" => "e159",
     "moon-truck" => "e15a",
     "moon-bike" => "e15b",
     "moon-road" => "e15c",
     "moon-train" => "e15d",
     "moon-ship" => "e15e",
     "moon-boat" => "e15f",
     "moon-cube" => "e160",
     "moon-cube-2" => "e161",
     "moon-cube-3" => "e162",
     "moon-cube4" => "e163",
     "moon-pyramid" => "e164",
     "moon-pyramid-2" => "e165",
     "moon-cylinder" => "e166",
     "moon-package" => "e167",
     "moon-puzzle" => "e168",
     "moon-puzzle-2" => "e169",
     "moon-puzzle-3" => "e16a",
     "moon-puzzle-4" => "e16b",
     "moon-glasses" => "e16c",
     "moon-glasses-2" => "e16d",
     "moon-glasses-3" => "e16e",
     "moon-sun-glasses" => "e16f",
     "moon-accessibility" => "e170",
     "moon-accessibility-2" => "e171",
     "moon-brain" => "e172",
     "moon-target" => "e173",
     "moon-target-2" => "e174",
     "moon-target-3" => "e175",
     "moon-gun" => "e176",
     "moon-gun-ban" => "e177",
     "moon-shield" => "e178",
     "moon-shield-2" => "e179",
     "moon-shield-3" => "e17a",
     "moon-shield-4" => "e17b",
     "moon-soccer" => "e17c",
     "moon-football" => "e17d",
     "moon-baseball" => "e17e",
     "moon-basketball" => "e17f",
     "moon-golf" => "e180",
     "moon-hockey" => "e181",
     "moon-racing" => "e182",
     "moon-eight-ball" => "e183",
     "moon-bowling-ball" => "e184",
     "moon-bowling" => "e185",
     "moon-bowling-2" => "e186",
     "moon-lightning" => "e187",
     "moon-power" => "e188",
     "moon-power-2" => "e189",
     "moon-switch" => "e18a",
     "moon-power-cord" => "e18b",
     "moon-cord" => "e18c",
     "moon-socket" => "e18d",
     "moon-clipboard" => "e18e",
     "moon-clipboard-2" => "e18f",
     "moon-signup" => "e190",
     "moon-clipboard-3" => "e191",
     "moon-clipboard-4" => "e192",
     "moon-list" => "e193",
     "moon-list-2" => "e194",
     "moon-list-3" => "e195",
     "moon-numbered-list" => "e196",
     "moon-list-4" => "e197",
     "moon-list-5" => "e198",
     "moon-playlist" => "e199",
     "moon-grid" => "e19a",
     "moon-grid-2" => "e19b",
     "moon-grid-3" => "e19c",
     "moon-grid-4" => "e19d",
     "moon-grid-5" => "e19e",
     "moon-grid-6" => "e19f",
     "moon-tree-3" => "e1a0",
     "moon-tree-4" => "e1a1",
     "moon-tree-5" => "e1a2",
     "moon-menu" => "e1a3",
     "moon-menu-2" => "e1a4",
     "moon-circle-small" => "e1a5",
     "moon-menu-3" => "e1a6",
     "moon-menu-4" => "e1a7",
     "moon-menu-5" => "e1a8",
     "moon-menu-6" => "e1a9",
     "moon-menu-7" => "e1aa",
     "moon-menu-8" => "e1ab",
     "moon-menu-9" => "e1ac",
     "moon-cloud" => "e1ad",
     "moon-cloud-2" => "e1ae",
     "moon-cloud-3" => "e1af",
     "moon-cloud-download" => "e1b0",
     "moon-cloud-upload" => "e1b1",
     "moon-download-2" => "e1b2",
     "moon-upload-2" => "e1b3",
     "moon-download-3" => "e1b4",
     "moon-upload-3" => "e1b5",
     "moon-download-4" => "e1b6",
     "moon-upload-4" => "e1b7",
     "moon-download-5" => "e1b8",
     "moon-upload-5" => "e1b9",
     "moon-download-6" => "e1ba",
     "moon-upload-6" => "e1bb",
     "moon-download-7" => "e1bc",
     "moon-upload-7" => "e1bd",
     "moon-globe" => "e1be",
     "moon-globe-2" => "e1bf",
     "moon-globe-3" => "e1c0",
     "moon-earth" => "e1c1",
     "moon-network" => "e1c2",
     "moon-link" => "e1c3",
     "moon-link-2" => "e1c4",
     "moon-link-3" => "e1c5",
     "moon-link2" => "e1c6",
     "moon-link-4" => "e1c7",
     "moon-link-5" => "e1c8",
     "moon-link-6" => "e1c9",
     "moon-anchor" => "e1ca",
     "moon-flag" => "e1cb",
     "moon-flag-2" => "e1cc",
     "moon-flag-3" => "e1cd",
     "moon-flag-4" => "e1ce",
     "moon-flag-5" => "e1cf",
     "moon-flag-6" => "e1d0",
     "moon-attachment" => "e1d1",
     "moon-attachment-2" => "e1d2",
     "moon-eye" => "e1d3",
     "moon-eye-blocked" => "e1d4",
     "moon-eye-2" => "e1d5",
     "moon-eye-3" => "e1d6",
     "moon-eye-blocked-2" => "e1d7",
     "moon-eye-4" => "e1d8",
     "moon-eye-5" => "e1d9",
     "moon-eye-6" => "e1da",
     "moon-eye-7" => "e1db",
     "moon-eye-8" => "e1dc",
     "moon-bookmark" => "e1dd",
     "moon-bookmark-2" => "e1de",
     "moon-bookmarks" => "e1df",
     "moon-bookmark-3" => "e1e0",
     "moon-spotlight" => "e1e1",
     "moon-starburst" => "e1e2",
     "moon-snowflake" => "e1e3",
     "moon-temperature" => "e1e4",
     "moon-temperature-2" => "e1e5",
     "moon-weather-lightning" => "e1e6",
     "moon-weather-rain" => "e1e7",
     "moon-weather-snow" => "e1e8",
     "moon-windy" => "e1e9",
     "moon-fan" => "e1ea",
     "moon-umbrella" => "e1eb",
     "moon-sun" => "e1ec",
     "moon-sun-2" => "e1ed",
     "moon-brightness-high" => "e1ee",
     "moon-brightness-medium" => "e1ef",
     "moon-brightness-low" => "e1f0",
     "moon-brightness-contrast" => "e1f1",
     "moon-contrast" => "e1f2",
     "moon-moon" => "e1f3",
     "moon-bed" => "e1f4",
     "moon-bed-2" => "e1f5",
     "moon-star" => "e1f6",
     "moon-star-2" => "e1f7",
     "moon-star-3" => "e1f8",
     "moon-star-4" => "e1f9",
     "moon-star-5" => "e1fa",
     "moon-star-6" => "e1fb",
     "moon-heart" => "e1fc",
     "moon-heart-2" => "e1fd",
     "moon-heart-3" => "e1fe",
     "moon-heart-4" => "e1ff",
     "moon-heart-broken" => "e200",
     "moon-heart-5" => "e201",
     "moon-heart-6" => "e202",
     "moon-heart-broken-2" => "e203",
     "moon-heart-7" => "e204",
     "moon-heart-8" => "e205",
     "moon-heart-broken-3" => "e206",
     "moon-lips" => "e207",
     "moon-lips-2" => "e208",
     "moon-thumbs-up" => "e209",
     "moon-thumbs-up-2" => "e20a",
     "moon-thumbs-down" => "e20b",
     "moon-thumbs-down-2" => "e20c",
     "moon-thumbs-up-3" => "e20d",
     "moon-thumbs-up-4" => "e20e",
     "moon-thumbs-up-5" => "e20f",
     "moon-thumbs-up-6" => "e210",
     "moon-people" => "e211",
     "moon-man" => "e212",
     "moon-male" => "e213",
     "moon-woman" => "e214",
     "moon-female" => "e215",
     "moon-peace" => "e216",
     "moon-yin-yang" => "e217",
     "moon-happy" => "e218",
     "moon-happy-2" => "e219",
     "moon-smiley" => "e21a",
     "moon-smiley-2" => "e21b",
     "moon-tongue" => "e21c",
     "moon-tongue-2" => "e21d",
     "moon-sad" => "e21e",
     "moon-sad-2" => "e21f",
     "moon-wink" => "e220",
     "moon-wink-2" => "e221",
     "moon-grin" => "e222",
     "moon-grin-2" => "e223",
     "moon-cool" => "e224",
     "moon-cool-2" => "e225",
     "moon-angry" => "e226",
     "moon-angry-2" => "e227",
     "moon-evil" => "e228",
     "moon-evil-2" => "e229",
     "moon-shocked" => "e22a",
     "moon-shocked-2" => "e22b",
     "moon-confused" => "e22c",
     "moon-confused-2" => "e22d",
     "moon-neutral" => "e22e",
     "moon-neutral-2" => "e22f",
     "moon-wondering" => "e230",
     "moon-wondering-2" => "e231",
     "moon-cursor" => "e232",
     "moon-cursor-2" => "e233",
     "moon-point-up" => "e234",
     "moon-point-right" => "e235",
     "moon-point-down" => "e236",
     "moon-point-left" => "e237",
     "moon-pointer" => "e238",
     "moon-hand" => "e239",
     "moon-stack-empty" => "e23a",
     "moon-stack-plus" => "e23b",
     "moon-stack-minus" => "e23c",
     "moon-stack-star" => "e23d",
     "moon-stack-picture" => "e23e",
     "moon-stack-down" => "e23f",
     "moon-stack-up" => "e240",
     "moon-stack-cancel" => "e241",
     "moon-stack-checkmark" => "e242",
     "moon-stack-list" => "e243",
     "moon-stack-clubs" => "e244",
     "moon-stack-spades" => "e245",
     "moon-stack-hearts" => "e246",
     "moon-stack-diamonds" => "e247",
     "moon-stack-user" => "e248",
     "moon-stack" => "e249",
     "moon-stack-music" => "e24a",
     "moon-stack-play" => "e24b",
     "moon-move" => "e24c",
     "moon-resize" => "e24d",
     "moon-resize-2" => "e24e",
     "moon-warning" => "e24f",
     "moon-warning-2" => "e250",
     "moon-notification" => "e251",
     "moon-notification-2" => "e252",
     "moon-question" => "e253",
     "moon-question-2" => "e254",
     "moon-question-3" => "e255",
     "moon-question-4" => "e256",
     "moon-question-5" => "e257",
     "moon-plus-circle" => "e258",
     "moon-plus-circle-2" => "e259",
     "moon-minus-circle" => "e25a",
     "moon-minus-circle-2" => "e25b",
     "moon-info" => "e25c",
     "moon-info-2" => "e25d",
     "moon-blocked" => "e25e",
     "moon-cancel-circle" => "e25f",
     "moon-cancel-circle-2" => "e260",
     "moon-checkmark-circle" => "e261",
     "moon-checkmark-circle-2" => "e262",
     "moon-cancel" => "e263",
     "moon-spam" => "e264",
     "moon-close" => "e265",
     "moon-close-2" => "e266",
     "moon-close-3" => "e267",
     "moon-close-4" => "e268",
     "moon-close-5" => "e269",
     "moon-checkmark" => "e26a",
     "moon-checkmark-2" => "e26b",
     "moon-checkmark-3" => "e26c",
     "moon-checkmark-4" => "e26d",
     "moon-spell-check" => "e26e",
     "moon-minus" => "e26f",
     "moon-plus" => "e270",
     "moon-minus-2" => "e271",
     "moon-plus-2" => "e272",
     "moon-enter" => "e273",
     "moon-exit" => "e274",
     "moon-enter-2" => "e275",
     "moon-exit-2" => "e276",
     "moon-enter-3" => "e277",
     "moon-exit-3" => "e278",
     "moon-exit-4" => "e279",
     "moon-play" => "e27a",
     "moon-pause" => "e27b",
     "moon-stop" => "e27c",
     "moon-backward" => "e27d",
     "moon-forward-2" => "e27e",
     "moon-play-2" => "e27f",
     "moon-pause-2" => "e280",
     "moon-stop-2" => "e281",
     "moon-backward-2" => "e282",
     "moon-forward-3" => "e283",
     "moon-first" => "e284",
     "moon-last" => "e285",
     "moon-previous" => "e286",
     "moon-next" => "e287",
     "moon-eject" => "e288",
     "moon-volume-high" => "e289",
     "moon-volume-medium" => "e28a",
     "moon-volume-low" => "e28b",
     "moon-volume-mute" => "e28c",
     "moon-volume-mute-2" => "e28d",
     "moon-volume-increase" => "e28e",
     "moon-volume-decrease" => "e28f",
     "moon-volume-high-2" => "e290",
     "moon-volume-medium-2" => "e291",
     "moon-volume-low-2" => "e292",
     "moon-volume-mute-3" => "e293",
     "moon-volume-mute-4" => "e294",
     "moon-volume-increase-2" => "e295",
     "moon-volume-decrease-2" => "e296",
     "moon-volume5" => "e297",
     "moon-volume4" => "e298",
     "moon-volume3" => "e299",
     "moon-volume2" => "e29a",
     "moon-volume1" => "e29b",
     "moon-volume0" => "e29c",
     "moon-volume-mute-5" => "e29d",
     "moon-volume-mute-6" => "e29e",
     "moon-loop" => "e29f",
     "moon-loop-2" => "e2a0",
     "moon-loop-3" => "e2a1",
     "moon-loop-4" => "e2a2",
     "moon-loop-5" => "e2a3",
     "moon-shuffle" => "e2a4",
     "moon-shuffle-2" => "e2a5",
     "moon-wave" => "e2a6",
     "moon-wave-2" => "e2a7",
     "moon-arrow-first" => "e2a8",
     "moon-arrow-right" => "e2a9",
     "moon-arrow-up" => "e2aa",
     "moon-arrow-right-2" => "e2ab",
     "moon-arrow-down" => "e2ac",
     "moon-arrow-left" => "e2ad",
     "moon-arrow-up-2" => "e2ae",
     "moon-arrow-right-3" => "e2af",
     "moon-arrow-down-2" => "e2b0",
     "moon-arrow-left-2" => "e2b1",
     "moon-arrow-up-left" => "e2b2",
     "moon-arrow-up-3" => "e2b3",
     "moon-arrow-up-right" => "e2b4",
     "moon-arrow-right-4" => "e2b5",
     "moon-arrow-down-right" => "e2b6",
     "moon-arrow-down-3" => "e2b7",
     "moon-arrow-down-left" => "e2b8",
     "moon-arrow-left-3" => "e2b9",
     "moon-arrow-up-left-2" => "e2ba",
     "moon-arrow-up-4" => "e2bb",
     "moon-arrow-up-right-2" => "e2bc",
     "moon-arrow-right-5" => "e2bd",
     "moon-arrow-down-right-2" => "e2be",
     "moon-arrow-down-4" => "e2bf",
     "moon-arrow-down-left-2" => "e2c0",
     "moon-arrow-left-4" => "e2c1",
     "moon-arrow-up-left-3" => "e2c2",
     "moon-arrow-up-5" => "e2c3",
     "moon-arrow-up-right-3" => "e2c4",
     "moon-arrow-right-6" => "e2c5",
     "moon-arrow-down-right-3" => "e2c6",
     "moon-arrow-down-5" => "e2c7",
     "moon-arrow-down-left-3" => "e2c8",
     "moon-arrow-left-5" => "e2c9",
     "moon-arrow-up-left-4" => "e2ca",
     "moon-arrow-up-6" => "e2cb",
     "moon-arrow-up-right-4" => "e2cc",
     "moon-arrow-right-7" => "e2cd",
     "moon-arrow-down-right-4" => "e2ce",
     "moon-arrow-down-6" => "e2cf",
     "moon-arrow-down-left-4" => "e2d0",
     "moon-arrow-left-6" => "e2d1",
     "moon-arrow" => "e2d2",
     "moon-arrow-2" => "e2d3",
     "moon-arrow-3" => "e2d4",
     "moon-arrow-4" => "e2d5",
     "moon-arrow-5" => "e2d6",
     "moon-arrow-6" => "e2d7",
     "moon-arrow-7" => "e2d8",
     "moon-arrow-8" => "e2d9",
     "moon-arrow-up-left-5" => "e2da",
     "moon-arrow-square" => "e2db",
     "moon-arrow-up-right-5" => "e2dc",
     "moon-arrow-right-8" => "e2dd",
     "moon-arrow-down-right-5" => "e2de",
     "moon-arrow-down-7" => "e2df",
     "moon-arrow-down-left-5" => "e2e0",
     "moon-arrow-left-7" => "e2e1",
     "moon-arrow-up-7" => "e2e2",
     "moon-arrow-right-9" => "e2e3",
     "moon-arrow-down-8" => "e2e4",
     "moon-arrow-left-8" => "e2e5",
     "moon-arrow-up-8" => "e2e6",
     "moon-arrow-right-10" => "e2e7",
     "moon-arrow-bottom" => "e2e8",
     "moon-arrow-left-9" => "e2e9",
     "moon-arrow-up-left-6" => "e2ea",
     "moon-arrow-up-9" => "e2eb",
     "moon-arrow-up-right-6" => "e2ec",
     "moon-arrow-right-11" => "e2ed",
     "moon-arrow-down-right-6" => "e2ee",
     "moon-arrow-down-9" => "e2ef",
     "moon-arrow-down-left-6" => "e2f0",
     "moon-arrow-left-10" => "e2f1",
     "moon-arrow-up-left-7" => "e2f2",
     "moon-arrow-up-10" => "e2f3",
     "moon-arrow-up-right-7" => "e2f4",
     "moon-arrow-right-12" => "e2f5",
     "moon-arrow-down-right-7" => "e2f6",
     "moon-arrow-down-10" => "e2f7",
     "moon-arrow-down-left-7" => "e2f8",
     "moon-arrow-left-11" => "e2f9",
     "moon-arrow-up-11" => "e2fa",
     "moon-arrow-right-13" => "e2fb",
     "moon-arrow-down-11" => "e2fc",
     "moon-arrow-left-12" => "e2fd",
     "moon-arrow-up-12" => "e2fe",
     "moon-arrow-right-14" => "e2ff",
     "moon-arrow-down-12" => "e300",
     "moon-arrow-left-13" => "e301",
     "moon-arrow-up-13" => "e302",
     "moon-arrow-right-15" => "e303",
     "moon-arrow-down-13" => "e304",
     "moon-arrow-left-14" => "e305",
     "moon-arrow-up-14" => "e306",
     "moon-arrow-right-16" => "e307",
     "moon-arrow-down-14" => "e308",
     "moon-arrow-left-15" => "e309",
     "moon-arrow-up-15" => "e30a",
     "moon-arrow-right-17" => "e30b",
     "moon-arrow-down-15" => "e30c",
     "moon-arrow-left-16" => "e30d",
     "moon-arrow-up-16" => "e30e",
     "moon-arrow-right-18" => "e30f",
     "moon-arrow-down-16" => "e310",
     "moon-arrow-left-17" => "e311",
     "moon-menu-10" => "e312",
     "moon-menu-11" => "e313",
     "moon-menu-close" => "e314",
     "moon-menu-close-2" => "e315",
     "moon-enter-4" => "e316",
     "moon-enter-5" => "e317",
     "moon-esc" => "e318",
     "moon-backspace" => "e319",
     "moon-backspace-2" => "e31a",
     "moon-backspace-3" => "e31b",
     "moon-tab" => "e31c",
     "moon-transmission" => "e31d",
     "moon-transmission-2" => "e31e",
     "moon-sort" => "e31f",
     "moon-sort-2" => "e320",
     "moon-key-keyboard" => "e321",
     "moon-key-A" => "e322",
     "moon-key-up" => "e323",
     "moon-key-right" => "e324",
     "moon-key-down" => "e325",
     "moon-key-left" => "e326",
     "moon-command" => "e327",
     "moon-checkbox-checked" => "e328",
     "moon-checkbox-unchecked" => "e329",
     "moon-square" => "e32a",
     "moon-checkbox-partial" => "e32b",
     "moon-checkbox" => "e32c",
     "moon-checkbox-unchecked-2" => "e32d",
     "moon-checkbox-partial-2" => "e32e",
     "moon-checkbox-checked-2" => "e32f",
     "moon-checkbox-unchecked-3" => "e330",
     "moon-checkbox-partial-3" => "e331",
     "moon-radio-checked" => "e332",
     "moon-radio-unchecked" => "e333",
     "moon-circle" => "e334",
     "moon-circle-2" => "e335",
     "moon-crop" => "e336",
     "moon-crop-2" => "e337",
     "moon-vector" => "e338",
     "moon-rulers" => "e339",
     "moon-scissors" => "e33a",
     "moon-scissors-2" => "e33b",
     "moon-scissors-3" => "e33c",
     "moon-filter" => "e33d",
     "moon-filter-2" => "e33e",
     "moon-filter-3" => "e33f",
     "moon-filter-4" => "e340",
     "moon-font" => "e341",
     "moon-font-size" => "e342",
     "moon-type" => "e343",
     "moon-text-height" => "e344",
     "moon-text-width" => "e345",
     "moon-height" => "e346",
     "moon-width" => "e347",
     "moon-bold" => "e348",
     "moon-underline" => "e349",
     "moon-italic" => "e34a",
     "moon-strikethrough" => "e34b",
     "moon-strikethrough-2" => "e34c",
     "moon-font-size-2" => "e34d",
     "moon-bold-2" => "e34e",
     "moon-underline-2" => "e34f",
     "moon-italic-2" => "e350",
     "moon-strikethrough-3" => "e351",
     "moon-omega" => "e352",
     "moon-sigma" => "e353",
     "moon-nbsp" => "e354",
     "moon-page-break" => "e355",
     "moon-page-break-2" => "e356",
     "moon-superscript" => "e357",
     "moon-subscript" => "e358",
     "moon-superscript-2" => "e359",
     "moon-subscript-2" => "e35a",
     "moon-text-color" => "e35b",
     "moon-highlight" => "e35c",
     "moon-pagebreak" => "e35d",
     "moon-clear-formatting" => "e35e",
     "moon-table" => "e35f",
     "moon-table-2" => "e360",
     "moon-insert-template" => "e361",
     "moon-pilcrow" => "e362",
     "moon-left-to-right" => "e363",
     "moon-right-to-left" => "e364",
     "moon-paragraph-left" => "e365",
     "moon-paragraph-center" => "e366",
     "moon-paragraph-right" => "e367",
     "moon-paragraph-justify" => "e368",
     "moon-paragraph-left-2" => "e369",
     "moon-paragraph-center-2" => "e36a",
     "moon-paragraph-right-2" => "e36b",
     "moon-paragraph-justify-2" => "e36c",
     "moon-indent-increase" => "e36d",
     "moon-indent-decrease" => "e36e",
     "moon-paragraph-left-3" => "e36f",
     "moon-paragraph-center-3" => "e370",
     "moon-paragraph-right-3" => "e371",
     "moon-paragraph-justify-3" => "e372",
     "moon-indent-increase-2" => "e373",
     "moon-indent-decrease-2" => "e374",
     "moon-share" => "e375",
     "moon-new-tab" => "e376",
     "moon-new-tab-2" => "e377",
     "moon-popout" => "e378",
     "moon-embed" => "e379",
     "moon-code" => "e37a",
     "moon-console" => "e37b",
     "moon-seven-segment-0" => "e37c",
     "moon-seven-segment-1" => "e37d",
     "moon-seven-segment-2" => "e37e",
     "moon-seven-segment-3" => "e37f",
     "moon-seven-segment-4" => "e380",
     "moon-seven-segment-5" => "e381",
     "moon-seven-segment-6" => "e382",
     "moon-seven-segment-7" => "e383",
     "moon-seven-segment-8" => "e384",
     "moon-seven-segment-9" => "e385",
     "moon-share-2" => "e386",
     "moon-share-3" => "e387",
     "moon-mail" => "e388",
     "moon-mail-2" => "e389",
     "moon-mail-3" => "e38a",
     "moon-mail-4" => "e38b",
     "moon-google" => "e38c",
     "moon-google-plus" => "e38d",
     "moon-google-plus-2" => "e38e",
     "moon-google-plus-3" => "e38f",
     "moon-google-plus-4" => "e390",
     "moon-google-drive" => "e391",
     "moon-facebook" => "e392",
     "moon-facebook-2" => "e393",
     "moon-facebook-3" => "e394",
     "moon-facebook-4" => "e395",
     "moon-instagram" => "e396",
     "moon-twitter" => "e397",
     "moon-twitter-2" => "e398",
     "moon-twitter-3" => "e399",
     "moon-feed-2" => "e39a",
     "moon-feed-3" => "e39b",
     "moon-feed-4" => "e39c",
     "moon-youtube" => "e39d",
     "moon-youtube-2" => "e39e",
     "moon-vimeo" => "e39f",
     "moon-vimeo2" => "e3a0",
     "moon-vimeo-2" => "e3a1",
     "moon-lanyrd" => "e3a2",
     "moon-flickr" => "e3a3",
     "moon-flickr-2" => "e3a4",
     "moon-flickr-3" => "e3a5",
     "moon-flickr-4" => "e3a6",
     "moon-picassa" => "e3a7",
     "moon-picassa-2" => "e3a8",
     "moon-dribbble" => "e3a9",
     "moon-dribbble-2" => "e3aa",
     "moon-dribbble-3" => "e3ab",
     "moon-forrst" => "e3ac",
     "moon-forrst-2" => "e3ad",
     "moon-deviantart" => "e3ae",
     "moon-deviantart-2" => "e3af",
     "moon-steam" => "e3b0",
     "moon-steam-2" => "e3b1",
     "moon-github" => "e3b2",
     "moon-github-2" => "e3b3",
     "moon-github-3" => "e3b4",
     "moon-github-4" => "e3b5",
     "moon-github-5" => "e3b6",
     "moon-wordpress" => "e3b7",
     "moon-wordpress-2" => "e3b8",
     "moon-joomla" => "e3b9",
     "moon-blogger" => "e3ba",
     "moon-blogger-2" => "e3bb",
     "moon-tumblr" => "e3bc",
     "moon-tumblr-2" => "e3bd",
     "moon-yahoo" => "e3be",
     "moon-tux" => "e3bf",
     "moon-apple" => "e3c0",
     "moon-finder" => "e3c1",
     "moon-android" => "e3c2",
     "moon-windows" => "e3c3",
     "moon-windows8" => "e3c4",
     "moon-soundcloud" => "e3c5",
     "moon-soundcloud-2" => "e3c6",
     "moon-skype" => "e3c7",
     "moon-reddit" => "e3c8",
     "moon-linkedin" => "e3c9",
     "moon-lastfm" => "e3ca",
     "moon-lastfm-2" => "e3cb",
     "moon-delicious" => "e3cc",
     "moon-stumbleupon" => "e3cd",
     "moon-stumbleupon-2" => "e3ce",
     "moon-stackoverflow" => "e3cf",
     "moon-pinterest" => "e3d0",
     "moon-pinterest-2" => "e3d1",
     "moon-xing" => "e3d2",
     "moon-xing-2" => "e3d3",
     "moon-flattr" => "e3d4",
     "moon-foursquare" => "e3d5",
     "moon-foursquare-2" => "e3d6",
     "moon-paypal" => "e3d7",
     "moon-paypal-2" => "e3d8",
     "moon-paypal-3" => "e3d9",
     "moon-yelp" => "e3da",
     "moon-libreoffice" => "e3db",
     "moon-file-pdf" => "e3dc",
     "moon-file-openoffice" => "e3dd",
     "moon-file-word" => "e3de",
     "moon-file-excel" => "e3df",
     "moon-file-zip" => "e3e0",
     "moon-file-powerpoint" => "e3e1",
     "moon-file-xml" => "e3e2",
     "moon-file-css" => "e3e3",
     "moon-html5" => "e3e4",
     "moon-html5-2" => "e3e5",
     "moon-home-7" => "e3e6",
     "moon-home-8" => "e3e7",
     "moon-home-9" => "e3e8",
     "moon-home-10" => "e3e9",
     "moon-home-11" => "e3ea",
     "moon-office" => "e3eb",
     "moon-newspaper" => "e3ec",
     "moon-pencil" => "e3ed",
     "moon-pencil-2" => "e3ee",
     "moon-pencil-3" => "e3ef",
     "moon-pencil-4" => "e3f0",
     "moon-pencil-5" => "e3f1",
     "moon-pencil-6" => "e3f2",
     "moon-quill-3" => "e3f3",
     "moon-pen-5" => "e3f4",
     "moon-marker" => "e3f5",
     "moon-home-12" => "e3f6",
     "moon-marker-2" => "e3f7",
     "moon-blog" => "e3f8",
     "moon-blog-2" => "e3f9",
     "moon-brush" => "e3fa",
     "moon-palette" => "e3fb",
     "moon-palette-2" => "e3fc",
     "moon-eyedropper" => "e3fd",
     "moon-eyedropper-2" => "e3fe",
     "moon-droplet-2" => "e3ff",
     "moon-droplet-3" => "e400",
     "moon-droplet-4" => "e401",
     "moon-images" => "e402",
     "moon-image-4" => "e403",
     "moon-image-5" => "e404",
     "moon-image-6" => "e405",
     "moon-images-2" => "e406",
     "moon-image-7" => "e407",
     "moon-camera" => "e408",
     "moon-camera-2" => "e409",
     "moon-camera-3" => "e40a",
     "moon-camera-4" => "e40b",
     "moon-music-3" => "e40c",
     "moon-music-4" => "e40d",
     "moon-music-5" => "e40e",
     "moon-music-6" => "e40f",
     "moon-play-3" => "e410",
     "moon-play-4" => "e411",
     "moon-movie" => "e412",
     "moon-movie-2" => "e413",
     "moon-movie-3" => "e414",
     "moon-film" => "e415",
     "moon-film-2" => "e416",
     "moon-film-3" => "e417",
     "moon-film-4" => "e418",
     "moon-camera-5" => "e419",
     "moon-camera-6" => "e41a",
     "moon-camera-7" => "e41b",
     "moon-camera-8" => "e41c",
     "moon-camera-9" => "e41d",
     "moon-clubs" => "e41e",
     "moon-diamonds" => "e41f",
     "moon-king" => "e420",
     "moon-queen" => "e421",
     "moon-rock" => "e422",
     "moon-bishop" => "e423",
     "moon-knight" => "e424",
     "moon-pawn" => "e425",
     "moon-chess" => "e426",
     "moon-bullhorn" => "e427",
     "moon-megaphone" => "e428",
     "moon-new" => "e429",
     "moon-connection-2" => "e42a",
     "moon-connection-3" => "e42b",
     "moon-podcast-3" => "e42c",
     "moon-mic" => "e42d",
     "moon-mic-2" => "e42e",
     "moon-mic-3" => "e42f",
     "moon-mic-4" => "e430",
     "moon-mic-5" => "e431",
     "moon-book" => "e432",
     "moon-book-2" => "e433",
     "moon-books" => "e434",
     "moon-reading" => "e435",
     "moon-library" => "e436",
     "moon-library-2" => "e437",
     "moon-graduation" => "e438",
     "moon-file-7" => "e439",
     "moon-files" => "e43a",
     "moon-file-plus" => "e43b",
     "moon-file-minus" => "e43c",
     "moon-file-download" => "e43d",
     "moon-file-upload" => "e43e",
     "moon-file-check" => "e43f",
     "moon-file-remove-2" => "e440",
     "moon-file-8" => "e441",
     "moon-file-9" => "e442",
     "moon-file-plus-2" => "e443",
     "moon-file-minus-2" => "e444",
     "moon-file-download-2" => "e445",
     "moon-file-upload-2" => "e446",
     "moon-file-check-2" => "e447",
     "moon-paste" => "e448",
     "moon-paste-2" => "e449",
     "moon-paste-3" => "e44a",
     "moon-stack-2" => "e44b",
     "moon-stack-3" => "e44c",
     "moon-stack-4" => "e44d",
     "moon-folder-4" => "e44e",
     "moon-folder-download" => "e44f",
     "moon-folder-upload" => "e450",
     "moon-folder-plus-2" => "e451",
     "moon-folder-plus-3" => "e452",
     "moon-folder-minus" => "e453",
     "moon-folder-minus-2" => "e454",
     "moon-folder8" => "e455",
     "moon-folder-minus-3" => "e456",
     "moon-folder-plus-4" => "e457",
     "moon-folder-remove-2" => "e458",
     "moon-folder-download-2" => "e459",
     "moon-folder-upload-2" => "e45a",
     "moon-folder-download-3" => "e45b",
     "moon-folder-upload-3" => "e45c",
     "moon-folder-5" => "e45d",
     "moon-folder-open-2" => "e45e",
     "moon-folder-6" => "e45f",
     "moon-folder-open-3" => "e460",
     "moon-certificate" => "e461",
     "moon-cc" => "e462",
     "moon-tag-7" => "e463",
     "moon-tags" => "e464",
     "moon-tags-2" => "e465",
     "moon-tag-8" => "e466",
     "moon-barcode" => "e467",
     "moon-barcode-2" => "e468",
     "moon-qrcode" => "e469",
     "moon-ticket" => "e46a",
     "moon-cart" => "e46b",
     "moon-cart-2" => "e46c",
     "moon-cart-3" => "e46d",
     "moon-cart-4" => "e46e",
     "moon-cart-5" => "e46f",
     "moon-cart-6" => "e470",
     "moon-cart-7" => "e471",
     "moon-basket" => "e472",
     "moon-basket-2" => "e473",
     "moon-bag" => "e474",
     "moon-bag-2" => "e475",
     "moon-bag-3" => "e476",
     "moon-coin" => "e477",
     "moon-coins" => "e478",
     "moon-credit" => "e479",
     "moon-credit-2" => "e47a",
     "moon-calculate" => "e47b",
     "moon-calculate-2" => "e47c",
     "moon-support" => "e47d",
     "moon-phone-3" => "e47e",
     "moon-phone-4" => "e47f",
     "moon-call-incoming" => "e480",
     "moon-call-outgoing" => "e481",
     "moon-phone-5" => "e482",
     "moon-phone-6" => "e483",
     "moon-phone-hang-up" => "e484",
     "moon-phone-hang-up-2" => "e485",
     "moon-address-book" => "e486",
     "moon-address-book-2" => "e487",
     "moon-notebook" => "e488",
     "moon-envelop" => "e489",
     "moon-envelop-2" => "e48a",
     "moon-mail-send" => "e48b",
     "moon-envelop-opened" => "e48c",
     "moon-envelop-3" => "e48d",
     'icon-glass' => "000",
     'icon-music' => "001",
     'icon-search' => "002",
     'icon-envelope' => "003",
     'icon-heart' => "004",
     'icon-star' => "005",
     'icon-star-empty' => "006",
     'icon-user' => "007",
     'icon-film' => "008",
     'icon-th-large' => "009",
     'icon-th' => "00a",
     'icon-th-list' => "00b",
     'icon-ok' => "00c",
     'icon-remove' => "00d",
     'icon-zoom-in' => "00e",
     'icon-zoom-out' => "010",
     'icon-off' => "011",
     'icon-signal' => "012",
     'icon-cog' => "013",
     'icon-trash' => "014",
     'icon-home' => "015",
     'icon-file' => "016",
     'icon-time' => "017",
     'icon-road' => "018",
     'icon-download-alt' => "019",
     'icon-download' => "01a",
     'icon-upload' => "01b",
     'icon-inbox' => "01c",
     'icon-play-circle' => "01d",
     'icon-repeat' => "01e",
     'icon-refresh' => "021",
     'icon-list-alt' => "022",
     'icon-lock' => "023",
     'icon-flag' => "024",
     'icon-headphones' => "025",
     'icon-volume-off' => "026",
     'icon-volume-down' => "027",
     'icon-volume-up' => "028",
     'icon-qrcode' => "029",
     'icon-barcode' => "02a",
     'icon-tag' => "02b",
     'icon-tags' => "02c",
     'icon-book' => "02d",
     'icon-bookmark' => "02e",
     'icon-print' => "02f",
     'icon-camera' => "f030",
     'icon-font' => "f031",
     'icon-bold' => "f032",
     'icon-italic' => "f033",
     'icon-text-height' => "f034",
     'icon-text-width' => "f035",
     'icon-align-left' => "f036",
     'icon-align-center' => "f037",
     'icon-align-right' => "f038",
     'icon-align-justify' => "f039",
     'icon-list' => "03a",
     'icon-indent-left' => "f03b",
     'icon-indent-right' => "f03c",
     'icon-facetime-video' => "f03d",
     'icon-picture' => "f03e",
     'icon-pencil' => "f040",
     'icon-map-marker' => "f041",
     'icon-adjust' => "f042",
     'icon-tint' => "f043",
     'icon-edit' => "f044",
     'icon-share' => "f045",
     'icon-check' => "f046",
     'icon-move' => "f047",
     'icon-step-backward' => "f048",
     'icon-fast-backward' => "f049",
     'icon-backward' => "f04a",
     'icon-play' => "f04b",
     'icon-pause' => "f04c",
     'icon-stop' => "f04d",
     'icon-forward' => "f04e",
     'icon-fast-forward' => "f050",
     'icon-step-forward' => "f051",
     'icon-eject' => "f052",
     'icon-chevron-left' => "f053",
     'icon-chevron-right' => "f054",
     'icon-plus-sign' => "f055",
     'icon-minus-sign' => "f056",
     'icon-remove-sign' => "f057",
     'icon-ok-sign' => "f058",
     'icon-question-sign' => "f059",
     'icon-info-sign' => "f05a",
     'icon-screenshot' => "f05b",
     'icon-remove-circle' => "f05c",
     'icon-ok-circle' => "f05d",
     'icon-ban-circle' => "f05e",
     'icon-arrow-left' => "f060",
     'icon-arrow-right' => "f061",
     'icon-arrow-up' => "f062",
     'icon-arrow-down' => "f063",
     'icon-share-alt' => "f064",
     'icon-resize-full' => "f065",
     'icon-resize-small' => "f066",
     'icon-plus' => "f067",
     'icon-minus' => "f068",
     'icon-asterisk' => "f069",
     'icon-exclamation-sign' => "f06a",
     'icon-gift' => "f06b",
     'icon-leaf' => "f06c",
     'icon-fire' => "f06d",
     'icon-eye-open' => "f06e",
     'icon-eye-close' => "f070",
     'icon-warning-sign' => "f071",
     'icon-plane' => "f072",
     'icon-calendar' => "f073",
     'icon-random' => "f074",
     'icon-comment' => "f075",
     'icon-magnet' => "f076",
     'icon-chevron-up' => "f077",
     'icon-chevron-down' => "f078",
     'icon-retweet' => "f079",
     'icon-shopping-cart' => "f07a",
     'icon-folder-close' => "f07b",
     'icon-folder-open' => "f07c",
     'icon-resize-vertical' => "f07d",
     'icon-resize-horizontal' => "f07e",
     'icon-bar-chart' => "f080",
     'icon-twitter-sign' => "f081",
     'icon-facebook-sign' => "f082",
     'icon-camera-retro' => "f083",
     'icon-key' => "f084",
     'icon-cogs' => "f085",
     'icon-comments' => "f086",
     'icon-thumbs-up' => "f087",
     'icon-thumbs-down' => "f088",
     'icon-star-half' => "f089",
     'icon-heart-empty' => "f08a",
     'icon-signout' => "f08b",
     'icon-linkedin-sign' => "f08c",
     'icon-pushpin' => "f08d",
     'icon-external-link' => "f08d",
     'icon-signin' => "f090",
     'icon-trophy' => "f091",
     'icon-github-sign' => "f092",
     'icon-upload-alt' => "f093",
     'icon-lemon' => "f094",
     'icon-phone' => "f095",
     'icon-check-empty' => "f096",
     'icon-bookmark-empty' => "f097",
     'icon-phone-sign' => "f098",
     'icon-twitter' => "f099",
     'icon-facebook' => "f09a",
     'icon-github' => "f09b",
     'icon-unlock' => "f09c",
     'icon-credit-card' => "f09d",
     'icon-rss' => "f09e",
     'icon-hdd' => "f0a0",
     'icon-bullhorn' => "f0a1",
     'icon-bell' => "f0a2",
     'icon-certificate' => "f0a3",
     'icon-hand-right' => "f0a4",
     'icon-hand-left' => "f0a5",
     'icon-hand-up' => "f0a6",
     'icon-hand-down' => "f0a7",
     'icon-circle-arrow-left' => "f0a8",
     'icon-circle-arrow-right' => "f0a9",
     'icon-circle-arrow-up' => "f0aa",
     'icon-circle-arrow-down' => "f0ab",
     'icon-globe' => "f0ac",
     'icon-wrench' => "f0ad",
     'icon-tasks' => "f0ae",
     'icon-filter' => "f0b0",
     'icon-briefcase' => "f0b1",
     'icon-fullscreen' => "f0b2",
     'icon-group' => "f0c0",
     'icon-link' => "f0c1",
     'icon-cloud' => "f0c2",
     'icon-beaker' => "f0c3",
     'icon-cut' => "f0c4",
     'icon-copy' => "f0c5",
     'icon-paper-clip' => "f0c6",
     'icon-save' => "f0c7",
     'icon-sign-blank' => "f0c8",
     'icon-reorder' => "f0c9",
     'icon-list-ul' => "f0ca",
     'icon-list-ol' => "f0cb",
     'icon-strikethrough' => "f0cc",
     'icon-underline' => "f0cd",
     'icon-table' => "f0ce",
     'icon-magic' => "f0d0",
     'icon-truck' => "f0d1",
     'icon-pinterest' => "f0d2",
     'icon-pinterest-sign' => "f0d3",
     'icon-google-plus-sign' => "f0d4",
     'icon-google-plus' => "f0d5",
     'icon-money' => "f0d6",
     'icon-caret-down' => "f0d7",
     'icon-caret-up' => "f0d8",
     'icon-caret-left' => "f0d9",
     'icon-caret-right' => "f0da",
     'icon-columns' => "f0db",
     'icon-sort' => "f0dc",
     'icon-sort-down' => "f0dd",
     'icon-sort-up' => "f0de",
     'icon-envelope-alt' => "f0e0",
     'icon-linkedin' => "f0e1",
     'icon-undo' => "f0e2",
     'icon-legal' => "f0e3",
     'icon-dashboard' => "f0e4",
     'icon-comment-alt' => "f0e5",
     'icon-comments-alt' => "f0e6",
     'icon-bolt' => "f0e7",
     'icon-sitemap' => "f0e8",
     'icon-umbrella' => "f0e9",
     'icon-paste' => "f0ea",
     'icon-lightbulb' => "f0eb",
     'icon-exchange' => "f0ec",
     'icon-cloud-download' => "f0ed",
     'icon-cloud-upload' => "f0ee",
     'icon-user-md' => "f0f0",
     'icon-stethoscope' => "f0f1",
     'icon-suitcase' => "f0f2",
     'icon-bell-alt' => "f0f3",
     'icon-coffee' => "f0f4",
     'icon-food' => "f0f5",
     'icon-file-alt' => "f0f6",
     'icon-building' => "f0f7",
     'icon-hospital' => "f0f8",
     'icon-ambulance' => "f0f9",
     'icon-medkit' => "f0fa",
     'icon-fighter-jet' => "f0fb",
     'icon-beer' => "f0fc",
     'icon-h-sign' => "f0fd",
     'icon-plus-sign-alt' => "f0fe",
     'icon-double-angle-left' => "f100",
     'icon-double-angle-right' => "f101",
     'icon-double-angle-up' => "f102",
     'icon-double-angle-down' => "f103",
     'icon-angle-left' => "f104",
     'icon-angle-right' => "f105",
     'icon-angle-up' => "f106",
     'icon-angle-down' => "f107",
     'icon-desktop' => "f108",
     'icon-laptop' => "f109",
     'icon-tablet' => "f10a",
     'icon-mobile-phone' => "f10b",
     'icon-circle-blank' => "f10c",
     'icon-quote-left' => "f10d",
     'icon-quote-right' => "f10e",
     'icon-spinner' => "f110",
     'icon-circle' => "f111",
     'icon-reply' => "f112",
     'icon-github-alt' => "f113",
     'icon-folder-close-alt' => "f114",
     'icon-folder-open-alt' => "f115",
     'icon-expand-alt' => "f116",
     'icon-collapse-alt' => "f117",
     'icon-smile' => "f118",
     'icon-frown' => "f119",
     'icon-meh' => "f11a",
     'icon-gamepad' => "f11b",
     'icon-keyboard' => "f11c",
     'icon-flag-alt' => "f11d",
     'icon-flag-checkered' => "f11e",
     'icon-terminal' => "f120",
     'icon-code' => "f121",
     'icon-reply-all' => "f122",
     'icon-mail-reply-all' => "f122",
     'icon-star-half-full' => "f123",
     'icon-location-arrow' => "f124",
     'icon-crop' => "f125",
     'icon-code-fork' => "f126",
     'icon-unlink' => "f127",
     'icon-question' => "f128",
     'icon-info' => "f129",
     'icon-exclamation' => "f12a",
     'icon-superscript' => "f12b",
     'icon-subscript' => "f12c",
     'icon-eraser' => "f12d",
     'icon-puzzle-piece' => "f12e",
     'icon-microphone' => "f130",
     'icon-microphone-off' => "f131",
     'icon-shield' => "f132",
     'icon-calendar-empty' => "f133",
     'icon-fire-extinguisher' => "f134",
     'icon-rocket' => "f135",
     'icon-maxcdn' => "f136",
     'icon-chevron-sign-left' => "f137",
     'icon-chevron-sign-right' => "f138",
     'icon-chevron-sign-up' => "f139",
     'icon-chevron-sign-down' => "f13a",
     'icon-html5' => "f13b",
     'icon-css3' => "f13c",
     'icon-anchor' => "f13d",
     'icon-unlock-alt' => "f13e",
     'icon-bullseye' => "f140",
     'icon-ellipsis-horizontal' => "f141",
     'icon-ellipsis-vertical' => "f142",
     'icon-rss-sign' => "f143",
     'icon-play-sign' => "f144",
     'icon-ticket' => "f145",
     'icon-minus-sign-alt' => "f146",
     'icon-check-minus' => "f147",
     'icon-level-up' => "f148",
     'icon-level-down' => "f149",
     'icon-check-sign' => "f14a",
     'icon-edit-sign' => "f14b",
     'icon-external-link-sign' => "f14c",
     'icon-share-sign' => "f14d",
     'icon-compass' => "f14e",
     'icon-collapse' => "f150",
     'icon-collapse-top' => "f151",
     'icon-expand' => "f152",
     'icon-eur' => "f153",
     'icon-gbp' => "f154",
     'icon-usd' => "f155",
     'icon-inr' => "f156",
     'icon-jpy' => "f157",
     'icon-cny' => "f158",
     'icon-krw' => "f159",
     'icon-btc' => "f15a",
     'icon-file' => "f15b",
     'icon-file-text' => "f15c",
     'icon-sort-by-alphabet' => "f15d",
     'icon-sort-by-alphabet-alt' => "f15e",
     'icon-sort-by-attributes' => "f160",
     'icon-sort-by-attributes-alt' => "f161",
     'icon-sort-by-order' => "f162",
     'icon-sort-by-order-alt' => "f163",
     'icon-thumbs-up' => "f164",
     'icon-thumbs-down' => "f165",
     'icon-youtube-sign' => "f166",
     'icon-youtube' => "f167",
     'icon-xing' => "f168",
     'icon-xing-sign' => "f169",
     'icon-youtube-play' => "f16a",
     'icon-dropbox' => "f16b",
     'icon-stackexchange' => "f16c",
     'icon-instagram' => "f16d",
     'icon-flickr' => "f16e",
     'icon-adn' => "f170",
     'icon-bitbucket' => "f171",
     'icon-bitbucket-sign' => "f172",
     'icon-tumblr' => "f173",
     'icon-tumblr-sign' => "f174",
     'icon-long-arrow-down' => "f175",
     'icon-long-arrow-up' => "f176",
     'icon-long-arrow-left' => "f177",
     'icon-long-arrow-right' => "f178",
     'icon-apple' => "f179",
     'icon-windows' => "f17a",
     'icon-android' => "f17b",
     'icon-linux' => "f17c",
     'icon-dribble' => "f17d",
     'icon-skype' => "f17e",
     'icon-foursquare' => "f180",
     'icon-trello' => "f181",
     'icon-female' => "f182",
     'icon-male' => "f183",
     'icon-gittip' => "f184",
     'icon-sun' => "f185",
     'icon-moon' => "f186",
     'icon-archive' => "f187",
     'icon-bug' => "f188",
     'icon-vk' => "f189",
     'icon-weibo' => "f18a",
     'icon-renren' => "f18b"
);
$skin_color            = '';
$skin_color            = get_option(THEME_OPTIONS, 'skin_color');


